﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Collections.Generic" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>ZPCHR - pracownicy niepełnosprawni</title>
		<script runat="server">

	public class PrnParams: Soneta.Business.ContextBase {
		public PrnParams(Context context): base(context) {
			Date data = Date.Empty;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			if (data==Date.Empty)
				data = Date.Today;
			miesiąc = new YearMonth(data);
		}
		
		YearMonth miesiąc;
		[Required]
        [Priority(10)]
        [Caption("Raport za")]
		public YearMonth Miesiąc {
			get { return miesiąc; }
			set { 
				miesiąc = value; 
				OnChanged(EventArgs.Empty);
			}
		}

        ZPCHR.WarunkiNaliczania warunkiNaliczaniaDla = ZPCHR.WarunkiNaliczania.PFRON;
        [Priority(20)]
        public ZPCHR.WarunkiNaliczania WarunkiNaliczaniaDla {
            get { return warunkiNaliczaniaDla; }
            set {
                warunkiNaliczaniaDla = value;
                OnChanged(EventArgs.Empty);
            }
        }        
	}
	
	PrnParams pars = null; 
	[Soneta.Business.Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 

    Dictionary<OddzialFirmy, List<Pracownik>> dict = new Dictionary<OddzialFirmy, List<Pracownik>>();
    List<OddzialFirmy> oddzialy = new List<OddzialFirmy>();
	FromTo okres;
    string title;
    ZPCHR zpchr;

	void OnContextLoad(Object sender, EventArgs args) {
		ReportHeader1["MIESIĄC"] = pars.Miesiąc.ToString();
        ReportHeader1["RAPORT"] = CaptionAttribute.EnumToString(pars.WarunkiNaliczaniaDla);
        title = ReportHeader1.Title;
        
        okres = pars.Miesiąc.ToFromTo();
        bool jestZpchr = Soneta.Core.CoreModule.GetInstance(dc).Config.Firma.StatusZPChr.Posiada;
        zpchr = new ZPCHR(jestZpchr, okres, pars.WarunkiNaliczaniaDla);

		KadryModule kadry = KadryModule.GetInstance(dc);
        Soneta.Business.View view = kadry.Pracownicy.GetNaEtatach(okres, (Wydzial)null, false, true);
        view.Sort = "NazwiskoImię";

        List<Pracownik> list;
        if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
            Date data = okres.From;
            foreach (Pracownik pracownik in view) {
                PracHistoria ph = pracownik[data];
                OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                while (of != null) {
			        if (of.GetObjectRight() != AccessRights.Denied &&
                        of.Deklaracje.PFRON == NaliczanieDeklaracjiOddziału.Naliczaj)
                        break;
                    of = of.Nadrzedny;
                }
                if (of == null)
                    continue;
                if (!dict.TryGetValue(of, out list))
                    dict.Add(of, list = new List<Pracownik>());
                list.Add(pracownik);
            }
        }
        else {
            dict.Add(new OddzialFirmy(RowCreator.Empty), list = new List<Pracownik>());
            foreach (Pracownik pracownik in view)
                list.Add(pracownik);
        }

        oddzialy.AddRange(dict.Keys);
        DataRepeater1.DataSource = oddzialy;
	}

	void OnBeforeRow(Object sender, EventArgs args) {
        OddzialFirmy of = (OddzialFirmy)DataRepeater1.CurrentRow;
        ReportHeader1.Title = !string.IsNullOrEmpty(of.Symbol) ? title.Replace("%ODDZIAL%", "Oddział: " + of) : title.Replace("%ODDZIAL%", "");

        Grid1.DataSource = dict[of];
    }

    Set<Pracownik> podstawowi = new Set<Pracownik>();

    void Grid1_OnBeforeRow(Object sender, RowEventArgs args) {
		Pracownik pracownik = (Pracownik)args.Row;

        Pracownik prc = pracownik.EtatGłówny;
        if (podstawowi.Contains(prc)) {
            args.VisibleRow = false;
            return;
        }
        podstawowi.Add(prc);
        
		IEnumerable it = zpchr[prc];
		bool any = false;
		string dod = "";
		string ddo = "";
		string wym = "";
		string stn = "";
		foreach (ZPCHR.OkresInfo info in it)
			if (info.Wchodzi && info.STN!=0) {
				dod += (info.Okres.From==okres.From ? "" : info.Okres.From.ToString()) + "<br>";
				ddo += (info.Okres.To==okres.To ? "" : info.Okres.To.ToString()) + "<br>";
				wym += info.Wymiar + "<br>";
				stn += info.STN + "<br>";
				any = true;
			}
		if (any) {
			odDnia.EditValue = dod.Substring(0, dod.Length-4);
			doDnia.EditValue = ddo.Substring(0, ddo.Length-4);
			wymiar.EditValue = wym.Substring(0, wym.Length-4);
			stopień.EditValue = stn.Substring(0, stn.Length-4);
		}
		else
			args.VisibleRow = false;
	}
	
	static void Msg(object obj) {
	}	
	
		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="PracownicyNiepełnosprawni" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%"
                onbeforerow="OnBeforeRow">
                <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
                <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" 
                    title="PRACOWNICY NIEPEŁNOSPRAWNI|&lt;/strong&gt;Raport za: &lt;strong&gt;%MIESIĄC%|&lt;/strong&gt;Statystyka: &lt;strong&gt;%RAPORT%|%ODDZIAL%" 
                    runat="server"></cc1:reportheader>
                    <ea:grid id="Grid1" runat="server" RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" onbeforerow="Grid1_OnBeforeRow">
				    <Columns>
					    <ea:GridColumn Width="4" Align="Center" DataMember="#" Caption="Lp." 
                            NoWrap="True" VAlign="Top"></ea:GridColumn>
					    <ea:GridColumn Width="40" DataMember="NazwiskoImię" Caption="Pracownik" NoWrap="True" VAlign="Top"></ea:GridColumn>
					    <ea:GridColumn Align="Center" DataMember="PESEL" VAlign="Top"></ea:GridColumn>
					    <ea:GridColumn Align="Center" Caption="Od dnia" ID="odDnia" VAlign="Top"></ea:GridColumn>
					    <ea:GridColumn Align="Center" Caption="Do dnia" ID="doDnia" VAlign="Top"></ea:GridColumn>
					    <ea:GridColumn Align="Center" Caption="Wymiar etatu" ID="wymiar" VAlign="Top"></ea:GridColumn>
					    <ea:GridColumn Align="Center" Caption="Stopień niepełnospr." ID="stopień" VAlign="Top"></ea:GridColumn>
				    </Columns>
			    </ea:grid>
                <cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter>
			</ea:DataRepeater>
        </form>
	</body>
</HTML>

